/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.mediasvc.DeviceLock;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockListener;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceProperties;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class MediaDeviceIdentifier {
    private static final String TRACE_MASKT = "XMDAMDIT";
    private static final String TRACE_MASKF = "XMDAMDIF";
    private static final String TRACE_MASKD = "XMDAMDID";
    private MediaDeviceProperties mediaDeviceProperties;
    private DeviceLock deviceLock;
    private LocalizableText currentLockOwner;
    public static final String DEVICE_DISKETTE = "DD";
    public static final String DEVICE_CDROM = "CD";
    public static final String DEVICE_DVDRAM = "DV";
    public static final String DEVICE_HDPARTITION = "HD";

    MediaDeviceIdentifier(MediaDeviceProperties mdp) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceIdentifier.MediaDeviceIdentifier(MediaDeviceProperties = " + mdp + ")");
        this.mediaDeviceProperties = mdp;
        this.deviceLock = new DeviceLock();
        Trace.trace(TRACE_MASKT, "<- MediaDeviceIdentifier.MediaDeviceIdentifier()");
    }

    void lock() {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceIdentifier.lock()");
        this.deviceLock.setLock(true);
        Trace.trace(TRACE_MASKT, "<- MediaDeviceIdentifier.lock()");
    }

    void unlock() {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceIdentifier.unlock()");
        this.deviceLock.setLock(false);
        this.currentLockOwner = null;
        Trace.trace(TRACE_MASKT, "<- MediaDeviceIdentifier.unlock()");
    }

    public boolean isLocked() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.isLocked(): returns " + this.deviceLock.getLock());
        return this.deviceLock.getLock();
    }

    MediaDeviceProperties getMediaDeviceProperties() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.getMediaDeviceProperties()");
        return this.mediaDeviceProperties;
    }

    void setCurrentLockOwner(LocalizableText lockOwner) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceIdentifier.setCurrentLockOwner(" + lockOwner.toString() + ")");
        this.currentLockOwner = lockOwner;
        Trace.trace(TRACE_MASKT, "<- MediaDeviceIdentifier.setCurrentLockOwner()");
    }

    public int[] getSupportedMediaTypes() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.getSupportedMediaTypes()");
        return this.mediaDeviceProperties.getMediaSupported();
    }

    public LocalizableText getCurrentLockOwner() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.getCurrentLockOwner(): returns " + this.currentLockOwner);
        return this.currentLockOwner;
    }

    public LocalizableText getDisplayableDeviceName() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.getDisplayableDeviceName(): returns " + this.mediaDeviceProperties.getDisplayableName());
        return this.mediaDeviceProperties.getDisplayableName();
    }

    public LocalizableText getDisplayableDeviceDescription() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.getDisplayableDeviceDescription(): returns " + this.mediaDeviceProperties.getDisplayableDescription());
        return this.mediaDeviceProperties.getDisplayableDescription();
    }

    public String getDeviceName() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.getDeviceName(): returns " + this.mediaDeviceProperties.getDeviceName());
        return this.mediaDeviceProperties.getDeviceName();
    }

    public String getDeviceType() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.getDeviceType(): returns " + this.mediaDeviceProperties.getDeviceType());
        return this.mediaDeviceProperties.getDeviceType();
    }

    boolean isMediaSupported(int mediaType) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceIdentifier.isMediaSupported(" + mediaType + ")");
        boolean result = this.mediaDeviceProperties.isMediaSupported(mediaType);
        Trace.trace(TRACE_MASKT, "<- MediaDeviceIdentifier.isMediaSupported()");
        return result;
    }

    boolean isPreferred() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceIdentifier.isPreferred(): returns " + this.mediaDeviceProperties.isPreferred());
        return this.mediaDeviceProperties.isPreferred();
    }

    public void addDeviceLockListener(MediaDeviceLockListener listener) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceIdentifier.addDeviceLockListener(MediaDeviceLockListener = " + listener + ")");
        this.deviceLock.addDeviceLockListener(listener);
        Trace.trace(TRACE_MASKT, "<- MediaDeviceIdentifier.addDeviceLockListener()");
    }

    public void removeDeviceLockListener(MediaDeviceLockListener listener) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceIdentifier.removeDeviceLockListener(MediaDeviceLockListener = " + listener + ")");
        this.deviceLock.removeDeviceLockListener(listener);
        Trace.trace(TRACE_MASKT, "<- MediaDeviceIdentifier.removeDeviceLockListener()");
    }

    void notifyListenersOfLockRequest() {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceIdentifier.notifyListenersOfLockRequest()");
        this.deviceLock.notifyListeners(3);
        Trace.trace(TRACE_MASKT, "<- MediaDeviceIdentifier.notifyListenersOfLockRequest()");
    }
}

